//
//  Material.fsh
//  Untitled
//
//  Created by dutty on 10.10.10.
//  Copyright 2010 drahtwerk. All rights reserved.
//

#ifdef OGL_ES2
#	ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#	else
precision mediump float;
#	endif
#	define prec_high highp
#	define prec_med mediump
#	define prec_low lowp
#else 
#	define prec_high
#	define prec_med 
#	define prec_low 
#endif
 

uniform prec_med sampler2D u_gBuffer;
uniform prec_med sampler2D u_packedNormals;

varying vec3 v_eyeSpace_viewRay;
varying vec3 v_eyeSpace_light_xyz;
varying prec_high vec2 v_gBuffer_coord;

float depthFact = 512.0;

prec_med float UnpackFloat16( prec_med vec2 depth )
{
	prec_med vec2 unpack = vec2( 1024.0, 4.0 );
	return dot(unpack, depth);
}

void main()
{
	prec_low vec4 gBufferTexel = texture2D( u_gBuffer, v_gBuffer_coord );

	prec_med float depth = UnpackFloat16( gBufferTexel.rg ) / depthFact;
	prec_med vec3 eyeSpace_xyz = v_eyeSpace_viewRay * depth;
	
	// compute normal
	gBufferTexel.r = texture2D( u_packedNormals, gBufferTexel.ba ).r;
	prec_med vec3 eyeSpace_normal = vec3(gBufferTexel.ba * 2.0 - 1.0, gBufferTexel.r * 2.0 + 1.0);	
	 
	prec_med float light_inverseSquareLightRange = 0.005;
	prec_low vec4 light_color = vec4(1.0, 0.5, 1.0, 1.0);
	
	// computes light attenuation and direction
	prec_med vec3 light_dir = (v_eyeSpace_light_xyz - eyeSpace_xyz) * light_inverseSquareLightRange;
	prec_low float light_attenuation = clamp(1.0-dot(light_dir, light_dir), 0.0, 1.0);
	light_dir = normalize(light_dir);
	
	// lighting equation
	prec_low float light_diffuseInfluence = dot(eyeSpace_normal, light_dir) * light_attenuation;
	gl_FragColor = light_color * light_diffuseInfluence;
	
//	float k = clamp( Depth * 1.0 / depthFact, 0.0, 1.0); color = vec4( k, k, k, 1.0);
//	float k = clamp( eyeSpace_xyz.z / 512.0, 0.0, 1.0); color = vec4( k, k, k, 1.0);
//	color = vec4(  (eyeSpace_normal+1.0)/2.0, 1.0);
//	color = vec4(Attenuation,Attenuation,Attenuation,1.0);
}


